/**
 * Demo Code for demonstrating the ImageProcesor Package.
 */

import java.awt.*;
import javax.swing.*;
import java.awt.event.*;
import javax.media.*;
import javax.media.format.*;

public class FrameDemo extends JFrame implements ActionListener, WindowListener, MouseListener {
	
	private Container windowPane;
	private String buttonText[] = {"initPlayer", "getFrame", "getPixel", "saveJPG"};
	private JButton buttonArray[];
	private PicCanvas canvas;
	private Font f1;
	private JTextArea output;
	private ImageProcessor imp;
	private Player player;
	private Image pic;
	private int mousex = 0;
	private int mousey = 0;

	public static void main(String args[]) {
		FrameDemo driver = new FrameDemo();
	}
	
	public FrameDemo() {
		super();
		windowPane = getContentPane();
		windowPane.setLayout(new BorderLayout());
		f1 = new Font ("Dialogue", Font.BOLD, 20);
		
		initOutputScreen();
		
		addWindowListener(this);
		this.setSize(600, 400);
		this.setVisible(true);
		
		imp = new ImageProcessor();
		player = null;
	}
	
	private void initOutputScreen()
	{
		// picture Panel;
		//JPanel pCenter = new JPanel();
		canvas = new PicCanvas();
		canvas.addMouseListener(this);
		//pCenter.add(canvas);
		windowPane.add(canvas, BorderLayout.CENTER);
		
		// button Panel
		JPanel pRight = new JPanel();
		pRight.setLayout(new GridLayout(buttonText.length, 1));
		pRight.setBackground(Color.green);
		
		buttonArray = new JButton [buttonText.length];
		for (int i=0; i<(buttonText.length); i++)
		{
			buttonArray[i] = new JButton (buttonText[i]);
			buttonArray[i].setForeground(Color.blue);
			buttonArray[i].setFont(f1);
			buttonArray[i].addActionListener(this);
			pRight.add(buttonArray[i]);
		}
		windowPane.add(pRight, BorderLayout.EAST);
		
		// Bottom Text Window
		output = new JTextArea(5, 50);
		JPanel pBottom = new JPanel();
		pBottom.setBackground(Color.green);
		pBottom.add(output);
		windowPane.add(pBottom, BorderLayout.SOUTH);
	}

	
	public void actionPerformed(ActionEvent e) {
		if (e.getSource() == buttonArray[0]) {
			output.setText("");
			VideoFormat vFormat = new YUVFormat() ;
			player = imp.initPlayer(vFormat);
			output.setText("Player initialized");
		}
		else if (e.getSource() == buttonArray[1]) {
			output.setText("");
			if (player == null)
				output.setText("Please initialize the player first");
			else {
				pic = imp.getFrame(player);
				canvas.setParams(pic, 70,15);
			}
		}
		else if (e.getSource() == buttonArray[2]) {
			output.setText("");
			if (pic == null)
				output.setText("Please obtain a picture first");
			else {
				try {
					int[] newI = imp.getPixel(pic, mousex-70, mousey-15, 1, 1);
					int pixel = newI[0];
					int alpha = (pixel >> 24) & 0xff;
					int red   = (pixel >> 16) & 0xff;
					int green = (pixel >>  8) & 0xff;
					int blue  = (pixel      ) & 0xff;
					output.setText("Alpha: " + alpha + "\tRed: " + red + "\tGreen: " + green + "\tBlue: " + blue);
				}
				catch (InterruptedException exp) {}
			}
		}
		else if (e.getSource() == buttonArray[3]) {
			output.setText("");
			if (pic == null)
				output.setText("please obtain a picture first");
			else {
				imp.saveJPG(pic, "VideoFrame.jpg");
				output.setText("JPEG saved");
			}
		}
	}
	
	public void windowClosing (WindowEvent e)
	{
		Window w = e.getWindow();
		w.dispose();
	}
	
	public void windowClosed(WindowEvent e)
	{
		System.exit(0); 
	}
	 public void windowActivated(WindowEvent e){}
	 public void windowDeactivated(WindowEvent e){}
	 public void windowDeiconified(WindowEvent e){}
	 public void windowIconified(WindowEvent e) {}
	 public void windowOpened(WindowEvent e){}

	public void mouseClicked(MouseEvent e) {
		mousex = e.getX();
		mousey = e.getY();
		output.setText("");
		output.setText("Coordinate: " + (mousex - 70) + " , " + (mousey - 15) );		
	}

	public void mouseEntered(MouseEvent e) {}
	public void mouseExited(MouseEvent e) {}
	public void mousePressed(MouseEvent e) {}
	public void mouseReleased(MouseEvent e) {}
	
}